//Gemma-7B DATASET v1.0 Category: Breakout Game Clone ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>

#define MAX_Boulders 10
#define BOARD_SIZE 5

typedef struct boulder {
  int x, y;
  char status;
} boulder;

boulder boulders[MAX_Boulders];

void initializeBoulders() {
  for (int i = 0; i < MAX_Boulders; i++) {
    boulders[i].x = -1;
    boulders[i].y = -1;
    boulders[i].status = 'U';
  }
}

void placeBoulder(int x, int y) {
  for (int i = 0; i < MAX_Boulders; i++) {
    if (boulders[i].x == x && boulders[i].y == y) {
      boulders[i].status = 'P';
      return;
    }
  }

  boulders[MAX_Boulders - 1].x = x;
  boulders[MAX_Boulders - 1].y = y;
  boulders[MAX_Boulders - 1].status = 'P';
}

int main() {
  initializeBoulders();
  placeBoulder(2, 3);
  placeBoulder(3, 2);
  placeBoulder(4, 1);

  for (int y = 0; y < BOARD_SIZE; y++) {
    for (int x = 0; x < BOARD_SIZE; x++) {
      for (int i = 0; i < MAX_Boulders; i++) {
        if (boulders[i].x == x && boulders[i].y == y) {
          printf("B");
        } else if (boulders[i].x == -1 && boulders[i].y == -1) {
          printf(".");
        } else {
          printf(" ");
        }
      }
      printf("\n");
    }
  }

  return 0;
}