//Falcon-180B DATASET v1.0 Category: Recursive ; Style: Cyberpunk
#include <stdio.h>

#define MAX_LENGTH 1000

void print_array(int arr[], int length) {
    for (int i = 0; i < length; i++) {
        printf("%d ", arr[i]);
    }
    printf("\n");
}

void merge(int arr[], int left[], int left_length, int right[], int right_length) {
    int i = 0, j = 0, k = 0;
    while (i < left_length && j < right_length) {
        if (left[i] < right[j]) {
            arr[k++] = left[i++];
        } else {
            arr[k++] = right[j++];
        }
    }
    while (i < left_length) {
        arr[k++] = left[i++];
    }
    while (j < right_length) {
        arr[k++] = right[j++];
    }
}

void merge_sort(int arr[], int length) {
    if (length <= 1) {
        return;
    }
    int mid = length / 2;
    int left[mid], right[length - mid];
    for (int i = 0; i < mid; i++) {
        left[i] = arr[i];
    }
    for (int i = mid; i < length; i++) {
        right[i - mid] = arr[i];
    }
    merge_sort(left, mid);
    merge_sort(right, length - mid);
    merge(arr, left, mid, right, length - mid);
}

int main() {
    int arr[] = {5, 3, 8, 1, 6, 2, 7, 4};
    int length = sizeof(arr) / sizeof(arr[0]);
    printf("Unsorted Array: ");
    print_array(arr, length);
    merge_sort(arr, length);
    printf("Sorted Array: ");
    print_array(arr, length);
    return 0;
}