//GEMINI-pro DATASET v1.0 Category: Bitwise operations ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>

int main(int argc, char *argv[]) {
  // The case of the Curious Case of the Bitwise Operations
  // As you know, my dear Watson, Bitwise operations are a powerful tool in the arsenal of any programmer. They allow us to perform operations on individual bits, which can be very useful for a variety of tasks.

  // For example, we can use bitwise operations to:
  // - Set or unset individual bits
  // - Check if a bit is set or unset
  // - Perform logical operations on bits
  // - Shift bits left or right

  // In this example, we will explore some of the most common bitwise operations.

  // First, let's define a few variables that we will use in our examples.

  int a = 5; // 0101 in binary
  int b = 3; // 0011 in binary

  // The bitwise AND operator (&) performs a logical AND operation on each bit of the two operands. The result is a new value that is 1 only if both bits are 1.

  int andResult = a & b; // 0001 in binary
  printf("The result of a & b is %d\n", andResult);

  // The bitwise OR operator (|) performs a logical OR operation on each bit of the two operands. The result is a new value that is 1 if either bit is 1.

  int orResult = a | b; // 0111 in binary
  printf("The result of a | b is %d\n", orResult);

  // The bitwise XOR operator (^) performs a logical XOR operation on each bit of the two operands. The result is a new value that is 1 if the two bits are different.

  int xorResult = a ^ b; // 0110 in binary
  printf("The result of a ^ b is %d\n", xorResult);

  // The bitwise NOT operator (~) performs a logical NOT operation on each bit of the operand. The result is a new value that is the opposite of the original value.

  int notResult = ~a; // 1010 in binary
  printf("The result of ~a is %d\n", notResult);

  // The bitwise left shift operator (<<) shifts the bits of the operand to the left by the specified number of bits. The result is a new value that is multiplied by 2 raised to the power of the shift amount.

  int leftShiftResult = a << 2; // 010100 in binary
  printf("The result of a << 2 is %d\n", leftShiftResult);

  // The bitwise right shift operator (>>) shifts the bits of the operand to the right by the specified number of bits. The result is a new value that is divided by 2 raised to the power of the shift amount.

  int rightShiftResult = a >> 2; // 0001 in binary
  printf("The result of a >> 2 is %d\n", rightShiftResult);

  // These are just a few of the most common bitwise operations. There are many other bitwise operations that can be used to perform a variety of tasks.

  // I hope you find this example helpful, Watson. Now, go forth and use your newfound knowledge of bitwise operations to solve the most perplexing cases!
  
  return 0;
}