//GPT-4o-mini DATASET v1.0 Category: Firewall ; Style: calm
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pcap.h>
#include <netinet/ip.h>

#define MAX_RULES 100
#define RULE_SIZE 16

typedef struct {
    char action[RULE_SIZE];
    char ip[RULE_SIZE];
} Rule;

Rule rules[MAX_RULES];
int rule_count = 0;

void add_rule(const char *action, const char *ip) {
    if (rule_count < MAX_RULES) {
        strncpy(rules[rule_count].action, action, RULE_SIZE);
        strncpy(rules[rule_count].ip, ip, RULE_SIZE);
        rule_count++;
    } else {
        printf("Maximum rule limit reached.\n");
    }
}

int check_rule(const char *packet_ip) {
    for (int i = 0; i < rule_count; i++) {
        if (strcmp(rules[i].ip, packet_ip) == 0) {
            if (strcmp(rules[i].action, "DENY") == 0) {
                return 0; // Deny the packet
            }
            if (strcmp(rules[i].action, "ALLOW") == 0) {
                return 1; // Allow the packet
            }
        }
    }
    return 1; // Default allow if no rules matched
}

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct ip *ip_hdr = (struct ip *)(packet + 14); // Skip Ethernet header
    char packet_ip[INET_ADDRSTRLEN];

    inet_ntop(AF_INET, &(ip_hdr->ip_src), packet_ip, INET_ADDRSTRLEN);
    
    printf("Packet from IP: %s\n", packet_ip);

    if (check_rule(packet_ip)) {
        printf("Packet allowed.\n");
    } else {
        printf("Packet denied.\n");
    }
}

void initialize_rules() {
    add_rule("DENY", "192.168.1.5");
    add_rule("ALLOW", "192.168.1.100");
}

int main(int argc, char *argv[]) {
    char *dev;             // Name of the device to listen on
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;       // Handle for packet capture

    if (argc < 2) {
        fprintf(stderr, "Usage: %s <interface>\n", argv[0]);
        return EXIT_FAILURE;
    }

    dev = argv[1];

    initialize_rules();

    handle = pcap_open_live(dev, BUFSIZ, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Could not open device %s: %s\n", dev, errbuf);
        return EXIT_FAILURE;
    }

    pcap_loop(handle, 0, packet_handler, NULL);

    pcap_close(handle);
    return EXIT_SUCCESS;
}