//Code Llama-13B DATASET v1.0 Category: Socket programming ; Style: careful
// Program to create a simple socket server
#include <stdio.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>

int main(int argc, char **argv)
{
    // Create a socket
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0)
    {
        perror("Socket creation error");
        return 1;
    }

    // Bind the socket
    struct sockaddr_in addr;
    addr.sin_family = AF_INET;
    addr.sin_port = htons(54321);
    addr.sin_addr.s_addr = INADDR_ANY;
    if (bind(sock, (struct sockaddr *)&addr, sizeof(addr)) < 0)
    {
        perror("Bind error");
        return 1;
    }

    // Listen for incoming connections
    if (listen(sock, 3) < 0)
    {
        perror("Listen error");
        return 1;
    }

    // Accept incoming connections
    struct sockaddr_in client_addr;
    socklen_t client_len = sizeof(client_addr);
    int client_sock = accept(sock, (struct sockaddr *)&client_addr, &client_len);
    if (client_sock < 0)
    {
        perror("Accept error");
        return 1;
    }

    // Receive data from client
    char buffer[256];
    int n = recv(client_sock, buffer, sizeof(buffer), 0);
    if (n < 0)
    {
        perror("Recv error");
        return 1;
    }

    // Send data to client
    n = send(client_sock, "Hello, client!", 13, 0);
    if (n < 0)
    {
        perror("Send error");
        return 1;
    }

    // Close the socket
    close(sock);

    return 0;
}