//GEMINI-pro DATASET v1.0 Category: Building a HTTP Client ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

typedef struct {
    char *data;
    size_t size;
} buffer_t;

size_t curl_callback(void *ptr, size_t size, size_t nmemb, void *data)
{
    buffer_t *buf = (buffer_t *)data;
    size_t new_size = buf->size + (size * nmemb);
    buf->data = (char *)realloc(buf->data, new_size);
    if (!buf->data) {
        return 0;
    }
    memcpy(buf->data + buf->size, ptr, size * nmemb);
    buf->size = new_size;
    return size * nmemb;
}

int main(int argc, char *argv[])
{
    CURL *curl;
    CURLcode res;
    buffer_t buf = { NULL, 0 };

    curl = curl_easy_init();
    if (!curl) {
        fprintf(stderr, "Could not initialize curl.\n");
        return EXIT_FAILURE;
    }

    curl_easy_setopt(curl, CURLOPT_URL, "http://example.com");
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, curl_callback);
    curl_easy_setopt(curl, CURLOPT_WRITEDATA, &buf);

    res = curl_easy_perform(curl);
    if (res != CURLE_OK) {
        fprintf(stderr, "curl_easy_perform() failed: %s\n", curl_easy_strerror(res));
        curl_easy_cleanup(curl);
        return EXIT_FAILURE;
    }

    printf("%s", buf.data);
    free(buf.data);
    curl_easy_cleanup(curl);
    return EXIT_SUCCESS;
}