//GPT-4o-mini DATASET v1.0 Category: Browser Plugin ; Style: shocked
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_URL_LENGTH 256
#define SHOCKING_WORD "shocking"

typedef struct {
    char url[MAX_URL_LENGTH];
} WebPage;

void display_shocking_alert() {
    printf("\n============================\n");
    printf("! SHOCKING ALERT !\n");
    printf("============================\n");
    printf("You've visited a page with a shocking word!\n");
    printf("============================\n\n");
}

int contains_shocking_word(const char *url) {
    // Check if the URL contains the shocking word
    return strstr(url, SHOCKING_WORD) != NULL;
}

void analyze_page(WebPage *page) {
    printf("Analyzing page: %s\n", page->url);
    
    // Check for the shocking word
    if (contains_shocking_word(page->url)) {
        display_shocking_alert();
    } else {
        printf("No shocking content found. You're safe!\n");
    }
}

void simulate_browser_plugin() {
    // Create an array of URLs to simulate browser pages
    WebPage pages[] = {
        {"https://example.com/shocking-news"},
        {"https://example.com/news"},
        {"https://example.com/latest-shocking-update"},
        {"https://example.com/about"},
        {"https://shocking-stuff.com/incredible-facts"}
    };
    
    int num_pages = sizeof(pages) / sizeof(pages[0]);
    
    for (int i = 0; i < num_pages; i++) {
        analyze_page(&pages[i]);
    }
}

int main() {
    printf("Welcome to the Shocking Browser Plugin Simulator!\n");
    printf("This program will analyze web pages for shocking words...\n\n");
    
    // Simulate running the browser plugin
    simulate_browser_plugin();
    
    printf("Plugin simulation completed! Stay safe out there!\n");
    
    return 0;
}