//GPT-4o-mini DATASET v1.0 Category: Pixel Art Generator ; Style: systematic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define WIDTH 16
#define HEIGHT 16

// Define colors
const char* const colors[] = {
    "\033[0;30m", // Black
    "\033[0;31m", // Red
    "\033[0;32m", // Green
    "\033[0;33m", // Yellow
    "\033[0;34m", // Blue
    "\033[0;35m", // Magenta
    "\033[0;36m", // Cyan
    "\033[0;37m", // White
    "\033[0m"     // Reset
};

// Define a structure for a pixel
typedef struct {
    int r, g, b; // RGB values
} Pixel;

// 2D array to hold the pixel art
Pixel canvas[HEIGHT][WIDTH];

// Function to initialize the canvas with a background color
void initialize_canvas(Pixel bg_color) {
    for (int y = 0; y < HEIGHT; y++) {
        for (int x = 0; x < WIDTH; x++) {
            canvas[y][x] = bg_color;
        }
    }
}

// Function to set a pixel color at a specific position
void set_pixel(int x, int y, Pixel color) {
    if (x >= 0 && x < WIDTH && y >= 0 && y < HEIGHT) {
        canvas[y][x] = color;
    }
}

// Function to display the canvas as colored pixel art
void display_canvas() {
    for (int y = 0; y < HEIGHT; y++) {
        for (int x = 0; x < WIDTH; x++) {
            int color_index = (canvas[y][x].r > 0) ? 1 : 0; // example using red or black
            if (canvas[y][x].g > 0) color_index = 2; // green
            if (canvas[y][x].b > 0) color_index = 3; // yellow

            printf("%s  ", colors[color_index]); // Print color
        }
        printf("\033[0m\n"); // Reset color after each line
    }
}

// Function to create a simple pixel art design
void create_pixel_art() {
    // Drawing a simple house shape
    Pixel brown = {139, 69, 19}; // Brown
    Pixel green = {0, 128, 0};   // Green 
    Pixel blue = {0, 0, 255};     // Blue
    Pixel white = {255, 255, 255};  // White

    // Base of the house
    for (int x = 5; x < 11; x++) {
        for (int y = 10; y < 13; y++) {
            set_pixel(x, y, brown);
        }
    }

    // Roof of the house
    for (int x = 4; x < 12; x++) {
        set_pixel(x, 9, green);
        if (x > 4 && x < 11) {
            set_pixel(x, 8, green);
        }
    }

    // Door
    for (int x = 7; x < 9; x++) {
        for (int y = 12; y < 15; y++) {
            set_pixel(x, y, white);
        }
    }

    // Window on the left
    for (int x = 5; x < 7; x++) {
        for (int y = 11; y < 12; y++) {
            set_pixel(x, y, blue);
        }
    }

    // Window on the right
    for (int x = 9; x < 11; x++) {
        for (int y = 11; y < 12; y++) {
            set_pixel(x, y, blue);
        }
    }
}

int main() {
    // Define a background color (black)
    Pixel bg_color = {0, 0, 0}; // Black background
    
    // Initialize canvas
    initialize_canvas(bg_color);
    
    // Create pixel art
    create_pixel_art();
    
    // Display the canvas
    display_canvas();

    return 0;
}