//Gemma-7B DATASET v1.0 Category: Color Code Converter ; Style: realistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_COLOR_CODE 10

typedef struct ColorCode {
  int red;
  int green;
  int blue;
  int alpha;
} ColorCode;

ColorCode convert_color_code(char *color_code) {
  ColorCode color_code_obj;

  // Extract the RGB values from the color code
  char *rgb_values = strchr(color_code, '(');
  rgb_values++;
  char *red_value = strchr(rgb_values, ',');
  int red = atoi(red_value);

  char *green_value = strchr(red_value + 1, ',');
  int green = atoi(green_value);

  char *blue_value = strchr(green_value + 1, ')');
  int blue = atoi(blue_value);

  // Extract the alpha value (optional)
  int alpha = 0;
  if (strchr(blue_value + 1, 'a') != NULL) {
    char *alpha_value = strchr(blue_value + 1, 'a');
    alpha = atoi(alpha_value + 1);
  }

  // Initialize the color code object
  color_code_obj.red = red;
  color_code_obj.green = green;
  color_code_obj.blue = blue;
  color_code_obj.alpha = alpha;

  return color_code_obj;
}

int main() {
  char *color_code = "rgb(255, 255, 255)";
  ColorCode color_code_obj = convert_color_code(color_code);

  printf("Red: %d\n", color_code_obj.red);
  printf("Green: %d\n", color_code_obj.green);
  printf("Blue: %d\n", color_code_obj.blue);
  printf("Alpha: %d\n", color_code_obj.alpha);

  return 0;
}