//LLAMA2-13B DATASET v1.0 Category: String manipulation ; Style: detailed
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define MAX_STR_LEN 1024

// Function to reverse a string
void reverse_str(char *str) {
    int i, j;
    char temp;

    for (i = 0, j = strlen(str) - 1; i < j; i++, j--) {
        temp = str[i];
        str[i] = str[j];
        str[j] = temp;
    }
}

// Function to rotate a string
void rotate_str(char *str, int num_rotations) {
    int i, j;
    char temp;

    for (i = 0; i < num_rotations; i++) {
        for (j = 0; j < strlen(str) - 1; j++) {
            temp = str[j];
            str[j] = str[j + 1];
            str[j + 1] = temp;
        }
    }
}

// Function to find the longest common prefix of two strings
void find_lcp(char *str1, char *str2) {
    int i, j;
    char temp;

    for (i = 0, j = 0; i < strlen(str1) && j < strlen(str2);) {
        if (str1[i] == str2[j]) {
            i++;
            j++;
        } else {
            break;
        }
    }
    strcpy(str1 + i - j, str2 + j);
}

int main() {
    char str1[] = "The quick brown fox jumps over the lazy dog";
    char str2[] = "The quick brown fox jumps at the lazy dog";
    char str3[MAX_STR_LEN];

    // Example 1: Reverse a string
    reverse_str(str1);
    printf("Reversed string: %s\n", str1);

    // Example 2: Rotate a string
    rotate_str(str1, 3);
    printf("Rotated string: %s\n", str1);

    // Example 3: Find the longest common prefix of two strings
    find_lcp(str1, str2);
    printf("Longest common prefix: %s\n", str3);

    return 0;
}