//Gemma-7B DATASET v1.0 Category: Game of Life ; Style: energetic
#include <stdio.h>
#include <stdlib.h>

int main()
{
    int **board = NULL;
    int rows = 0;
    int cols = 0;
    int generation = 0;
    int seed = 12;

    // Allocate memory for the game board
    board = malloc(rows * sizeof(int *));
    for (int r = 0; r < rows; r++)
    {
        board[r] = malloc(cols * sizeof(int));
    }

    // Initialize the game board
    for (int r = 0; r < rows; r++)
    {
        for (int c = 0; c < cols; c++)
        {
            board[r][c] = 0;
        }
    }

    // Seed the random number generator
    srand(seed);

    // Create the initial generation
    for (int r = 0; r < rows; r++)
    {
        for (int c = 0; c < cols; c++)
        {
            board[r][c] = rand() % 2;
        }
    }

    // Play the game for multiple generations
    for (generation = 0; generation < 10; generation++)
    {
        // Calculate the next generation
        for (int r = 0; r < rows; r++)
        {
            for (int c = 0; c < cols; c++)
            {
                int num_neighbors = 0;
                for (int dr = -1; dr <= 1; dr++)
                {
                    for (int dc = -1; dc <= 1; dc++)
                    {
                        if (board[r + dr][c + dc] == 1)
                        {
                            num_neighbors++;
                        }
                    }
                }

                if (board[r][c] == 1 && num_neighbors < 2)
                {
                    board[r][c] = 0;
                }
                else if (board[r][c] == 0 && num_neighbors == 3)
                {
                    board[r][c] = 1;
                }
            }
        }

        // Print the game board
        for (int r = 0; r < rows; r++)
        {
            for (int c = 0; c < cols; c++)
            {
                printf("%d ", board[r][c]);
            }
            printf("\n");
        }

        // Pause the game
        system("pause");
    }

    // Free the memory allocated for the game board
    for (int r = 0; r < rows; r++)
    {
        free(board[r]);
    }
    free(board);

    return 0;
}