//GEMINI-pro DATASET v1.0 Category: Pathfinding algorithms ; Style: decentralized
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NODES 100
#define MAX_EDGES 1000

typedef struct node {
    int id;
    int x;
    int y;
    struct node *neighbors[MAX_NODES];
    int num_neighbors;
} node;

typedef struct edge {
    int from;
    int to;
    int weight;
} edge;

node nodes[MAX_NODES];
edge edges[MAX_EDGES];

int num_nodes;
int num_edges;

void add_node(int id, int x, int y) {
    nodes[num_nodes].id = id;
    nodes[num_nodes].x = x;
    nodes[num_nodes].y = y;
    nodes[num_nodes].num_neighbors = 0;
    num_nodes++;
}

void add_edge(int from, int to, int weight) {
    edges[num_edges].from = from;
    edges[num_edges].to = to;
    edges[num_edges].weight = weight;
    num_edges++;
}

void print_graph() {
    for (int i = 0; i < num_nodes; i++) {
        printf("Node %d: (%d, %d)\n", nodes[i].id, nodes[i].x, nodes[i].y);
        for (int j = 0; j < nodes[i].num_neighbors; j++) {
            printf("  - Neighbor %d: (%d, %d)\n", nodes[i].neighbors[j]->id, nodes[i].neighbors[j]->x, nodes[i].neighbors[j]->y);
        }
    }
}

int main() {
    // Add nodes
    add_node(0, 0, 0);
    add_node(1, 10, 0);
    add_node(2, 20, 0);
    add_node(3, 30, 0);
    add_node(4, 40, 0);

    // Add edges
    add_edge(0, 1, 1);
    add_edge(0, 2, 2);
    add_edge(0, 3, 3);
    add_edge(1, 2, 1);
    add_edge(1, 3, 2);
    add_edge(2, 3, 1);
    add_edge(2, 4, 1);
    add_edge(3, 4, 2);

    // Print the graph
    print_graph();

    return 0;
}