//MISTRAL-7B DATASET v1.0 Category: Networking ; Style: active
#include <arpa/inet.h>
#include <netinet/in.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

#define SERVER_PORT 8080
#define BUFFER_SIZE 1024
#define SA struct sockaddr_in

int main(int argc, char const *argv[]) {
    int sockfd, new_sockfd;
    SA server_addr, client_addr;
    socklen_t server_len, client_len;
    char buffer[BUFFER_SIZE] = {0};
    int read_size;

    // Create socket
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        perror("socket creation failed");
        exit(EXIT_FAILURE);
    }

    // Set up the address structure
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(SERVER_PORT);
    server_addr.sin_addr.s_addr = inet_addr("127.0.0.1");

    // Connect to the server
    if (connect(sockfd, (SA *)&server_addr, sizeof(server_addr)) < 0) {
        perror("connection failed");
        exit(EXIT_FAILURE);
    }

    // Send some data to the server
    if (send(sockfd, "Hello, server!", 13, 0) < 0) {
        perror("data sending failed");
        exit(EXIT_FAILURE);
    }

    // Receive data from the server
    read_size = recv(sockfd, buffer, BUFFER_SIZE, 0);
    if (read_size <= 0) {
        perror("data receiving failed");
        exit(EXIT_FAILURE);
    }

    printf("Server replied: %s\n", buffer);

    // Accept a new client connection
    if ((new_sockfd = accept(sockfd, (SA *)&client_addr, &client_len)) < 0) {
        perror("accept failed");
        exit(EXIT_FAILURE);
    }

    // Send data to the new client
    if (send(new_sockfd, "Hello, client!", 13, 0) < 0) {
        perror("data sending failed");
        exit(EXIT_FAILURE);
    }

    // Receive data from the new client
    read_size = recv(new_sockfd, buffer, BUFFER_SIZE, 0);
    if (read_size <= 0) {
        perror("data receiving failed");
        exit(EXIT_FAILURE);
    }

    printf("Client replied: %s\n", buffer);

    // Close the sockets
    close(sockfd);
    close(new_sockfd);

    return EXIT_SUCCESS;
}