//Falcon-180B DATASET v1.0 Category: Digital Auction System ; Style: optimized
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_ITEMS 100
#define MAX_USERS 50
#define MAX_BIDS 50
#define MAX_BID_HISTORY 50

typedef struct {
    char name[50];
    int id;
    int balance;
} User;

typedef struct {
    char name[50];
    int id;
    int price;
    int highestBid;
    int highestBidder;
    int numBids;
    int bidHistory[MAX_BID_HISTORY];
} Item;

User users[MAX_USERS];
Item items[MAX_ITEMS];

int numUsers = 0;
int numItems = 0;

void registerUser(char *name) {
    User *user = &users[numUsers];
    strcpy(user->name, name);
    user->id = numUsers;
    user->balance = 1000;
    numUsers++;
}

void addItem(char *name, int price) {
    Item *item = &items[numItems];
    strcpy(item->name, name);
    item->id = numItems;
    item->price = price;
    item->highestBid = 0;
    item->highestBidder = -1;
    item->numBids = 0;
    numItems++;
}

void placeBid(int userId, int itemId, int bid) {
    User *user = &users[userId];
    Item *item = &items[itemId];
    if (item->highestBid < bid) {
        item->highestBid = bid;
        item->highestBidder = userId;
    }
    item->numBids++;
    item->bidHistory[item->numBids - 1] = bid;
}

void viewItem(int itemId) {
    Item *item = &items[itemId];
    printf("Item %d: %s\n", item->id, item->name);
    printf("Price: $%d\n", item->price);
    printf("Highest bid: $%d by user %d\n", item->highestBid, item->highestBidder);
    printf("Number of bids: %d\n", item->numBids);
    for (int i = 0; i < item->numBids; i++) {
        printf("Bid %d: $%d\n", i + 1, item->bidHistory[i]);
    }
}

int main() {
    registerUser("John");
    registerUser("Jane");
    addItem("iPhone", 1000);
    addItem("MacBook", 2000);
    placeBid(0, 0, 1100);
    placeBid(1, 0, 1200);
    placeBid(0, 1, 2100);
    viewItem(0);
    viewItem(1);
    return 0;
}