//GEMINI-pro DATASET v1.0 Category: Encryption ; Style: complete
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the key for encryption
#define KEY "my_secret_key"

// Function to encrypt a string using XOR encryption
char* encrypt(const char* plaintext) {
    // Get the length of the plaintext
    size_t plaintext_len = strlen(plaintext);

    // Allocate memory for the ciphertext
    char* ciphertext = (char*)malloc(plaintext_len + 1);
    if (ciphertext == NULL) {
        perror("Error allocating memory for ciphertext");
        return NULL;
    }

    // Perform XOR encryption
    for (size_t i = 0; i < plaintext_len; i++) {
        ciphertext[i] = plaintext[i] ^ KEY[i % strlen(KEY)];
    }

    // Null-terminate the ciphertext
    ciphertext[plaintext_len] = '\0';

    // Return the ciphertext
    return ciphertext;
}

// Function to decrypt a string using XOR encryption
char* decrypt(const char* ciphertext) {
    // Get the length of the ciphertext
    size_t ciphertext_len = strlen(ciphertext);

    // Allocate memory for the plaintext
    char* plaintext = (char*)malloc(ciphertext_len + 1);
    if (plaintext == NULL) {
        perror("Error allocating memory for plaintext");
        return NULL;
    }

    // Perform XOR decryption
    for (size_t i = 0; i < ciphertext_len; i++) {
        plaintext[i] = ciphertext[i] ^ KEY[i % strlen(KEY)];
    }

    // Null-terminate the plaintext
    plaintext[ciphertext_len] = '\0';

    // Return the plaintext
    return plaintext;
}

int main() {
    // Define the plaintext
    char* plaintext = "Hello, world!";

    // Encrypt the plaintext
    char* ciphertext = encrypt(plaintext);
    if (ciphertext == NULL) {
        return EXIT_FAILURE;
    }

    // Print the ciphertext (encoded as hexadecimal)
    printf("Ciphertext (hex): ");
    for (size_t i = 0; i < strlen(ciphertext); i++) {
        printf("%02x", (unsigned char)ciphertext[i]);
    }
    printf("\n");

    // Decrypt the ciphertext
    char* decrypted_plaintext = decrypt(ciphertext);
    if (decrypted_plaintext == NULL) {
        free(ciphertext);
        return EXIT_FAILURE;
    }

    // Print the decrypted plaintext
    printf("Decrypted plaintext: %s\n", decrypted_plaintext);

    // Free the allocated memory
    free(ciphertext);
    free(decrypted_plaintext);

    return EXIT_SUCCESS;
}