//GPT-4o-mini DATASET v1.0 Category: Interprocess communication ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <math.h>
#include <wait.h>

// Function declarations
void squareCalculator(int writefd);
void circleCalculator(int writefd);
void readFromPipe(int readfd);

// Main program
int main() {
    int pipe1[2]; // Pipe for square calculator
    int pipe2[2]; // Pipe for circle calculator

    // Creating the pipes
    if (pipe(pipe1) == -1 || pipe(pipe2) == -1) {
        perror("Pipe creation failed");
        exit(EXIT_FAILURE);
    }

    // Forking process for square calculation
    if (fork() == 0) {
        close(pipe1[0]); // Close reading end
        squareCalculator(pipe1[1]);
        close(pipe1[1]); // Close writing end
        exit(0); // Child process exits
    }

    // Forking process for circle calculation
    if (fork() == 0) {
        close(pipe2[0]); // Close reading end
        circleCalculator(pipe2[1]);
        close(pipe2[1]); // Close writing end
        exit(0); // Child process exits
    }

    // Parent process
    close(pipe1[1]); // Close writing end of square pipe
    close(pipe2[1]); // Close writing end of circle pipe
    
    printf("Parent: Reading from child processes...\n");
    readFromPipe(pipe1[0]); // Read square calculation result
    readFromPipe(pipe2[0]); // Read circle calculation result

    // Wait for child processes to finish
    wait(NULL);
    wait(NULL);
    
    printf("Parent: All child processes have completed.\n");
    return 0;
}

void squareCalculator(int writefd) {
    int side = 5; // Example side length
    int area = side * side; // Calculate area of square
    write(writefd, &area, sizeof(area)); // Write result to pipe
    printf("Square Calculator: Area of square with side %d is %d\n", side, area);
}

void circleCalculator(int writefd) {
    double radius = 3.0; // Example radius
    double area = M_PI * radius * radius; // Calculate area of circle
    write(writefd, &area, sizeof(area)); // Write result to pipe
    printf("Circle Calculator: Area of circle with radius %.2f is %.2f\n", radius, area);
}

void readFromPipe(int readfd) {
    int int_result; // For integer results
    double double_result; // For double results

    // Read square area result
    if (read(readfd, &int_result, sizeof(int_result)) > 0) {
        printf("Parent: Received area from square calculator: %d\n", int_result);
    }

    // Read circle area result
    if (read(readfd, &double_result, sizeof(double_result)) > 0) {
        printf("Parent: Received area from circle calculator: %.2f\n", double_result);
    }
}