//GEMINI-pro DATASET v1.0 Category: Smart home automation ; Style: sophisticated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_DEVICES 10
#define MAX_COMMANDS 100

struct device {
    char name[32];
    int type;
    int state;
    int value;
};

struct command {
    char name[32];
    int type;
    int arg1;
    int arg2;
};

struct home {
    char name[32];
    int num_devices;
    struct device devices[MAX_DEVICES];
    int num_commands;
    struct command commands[MAX_COMMANDS];
};

struct home my_home = {
    .name = "My Home",
    .num_devices = 0,
    .num_commands = 0
};

void add_device(struct home *home, char *name, int type) {
    if (home->num_devices >= MAX_DEVICES) {
        printf("Error: Too many devices.\n");
        return;
    }

    struct device *device = &home->devices[home->num_devices++];
    strcpy(device->name, name);
    device->type = type;
    device->state = 0;
    device->value = 0;
}

void add_command(struct home *home, char *name, int type, int arg1, int arg2) {
    if (home->num_commands >= MAX_COMMANDS) {
        printf("Error: Too many commands.\n");
        return;
    }

    struct command *command = &home->commands[home->num_commands++];
    strcpy(command->name, name);
    command->type = type;
    command->arg1 = arg1;
    command->arg2 = arg2;
}

void execute_command(struct home *home, struct command *command) {
    switch (command->type) {
        case 0:  // Turn on device
            home->devices[command->arg1].state = 1;
            break;
        case 1:  // Turn off device
            home->devices[command->arg1].state = 0;
            break;
        case 2:  // Set device value
            home->devices[command->arg1].value = command->arg2;
            break;
        case 3:  // Get device value
            printf("%s: %d\n", home->devices[command->arg1].name, home->devices[command->arg1].value);
            break;
        default:
            printf("Error: Unknown command type.\n");
            break;
    }
}

void load_home(struct home *home) {
    // Add devices
    add_device(home, "Living Room Light", 0);
    add_device(home, "Kitchen Light", 0);
    add_device(home, "Bedroom Light", 0);
    add_device(home, "Living Room Fan", 1);
    add_device(home, "Kitchen Fan", 1);
    add_device(home, "Bedroom Fan", 1);

    // Add commands
    add_command(home, "Turn on living room light", 0, 0, 0);
    add_command(home, "Turn off living room light", 1, 0, 0);
    add_command(home, "Set living room fan to high", 2, 0, 2);
    add_command(home, "Get kitchen light value", 3, 1, 0);
    add_command(home, "Turn off bedroom fan", 1, 2, 0);
}

void print_home(struct home *home) {
    printf("Home: %s\n", home->name);
    printf("Devices:\n");
    for (int i = 0; i < home->num_devices; i++) {
        struct device *device = &home->devices[i];
        printf("  %s (%s, state: %d, value: %d)\n", device->name, device->type == 0 ? "light" : "fan", device->state, device->value);
    }
    printf("Commands:\n");
    for (int i = 0; i < home->num_commands; i++) {
        struct command *command = &home->commands[i];
        printf("  %s (%d, %d, %d)\n", command->name, command->type, command->arg1, command->arg2);
    }
}

int main() {
    load_home(&my_home);
    print_home(&my_home);

    // Execute commands
    execute_command(&my_home, &my_home.commands[0]);
    execute_command(&my_home, &my_home.commands[2]);
    execute_command(&my_home, &my_home.commands[3]);
    execute_command(&my_home, &my_home.commands[4]);

    print_home(&my_home);

    return 0;
}