//Falcon-180B DATASET v1.0 Category: Password management ; Style: innovative
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#define MAX_PASSWORDS 100

typedef struct {
    char website[100];
    char username[100];
    char password[100];
} password_t;

void add_password(password_t passwords[], int num_passwords, char* website, char* username, char* password) {
    if (num_passwords >= MAX_PASSWORDS) {
        printf("Error: Maximum number of passwords reached.\n");
        return;
    }

    strcpy(passwords[num_passwords].website, website);
    strcpy(passwords[num_passwords].username, username);
    strcpy(passwords[num_passwords].password, password);

    num_passwords++;
}

void remove_password(password_t passwords[], int num_passwords, char* website) {
    int i;

    for (i = 0; i < num_passwords; i++) {
        if (strcmp(passwords[i].website, website) == 0) {
            num_passwords--;

            if (i < num_passwords) {
                memmove(&passwords[i], &passwords[i+1], sizeof(password_t) * (num_passwords - i - 1));
            }

            break;
        }
    }
}

void print_passwords(password_t passwords[], int num_passwords) {
    int i;

    for (i = 0; i < num_passwords; i++) {
        printf("Website: %s\nUsername: %s\nPassword: %s\n\n", passwords[i].website, passwords[i].username, passwords[i].password);
    }
}

int main() {
    password_t passwords[MAX_PASSWORDS];
    int num_passwords = 0;

    add_password(passwords, num_passwords, "google.com", "myemail@gmail.com", "mypassword123");
    add_password(passwords, num_passwords, "facebook.com", "myemail@gmail.com", "mypassword456");
    add_password(passwords, num_passwords, "twitter.com", "myemail@gmail.com", "mypassword789");

    print_passwords(passwords, num_passwords);

    remove_password(passwords, num_passwords, "google.com");

    print_passwords(passwords, num_passwords);

    return 0;
}