//GEMINI-pro DATASET v1.0 Category: Database simulation ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct {
    char *name;
    int age;
} person;

typedef struct {
    char *name;
    int population;
} city;

int main() {
    // Create a database of people
    person people[] = {
        {"Alice", 20},
        {"Bob", 30},
        {"Carol", 40},
        {"Dave", 50},
        {"Eve", 60}
    };
    int num_people = sizeof(people) / sizeof(person);

    // Create a database of cities
    city cities[] = {
        {"New York City", 8000000},
        {"Los Angeles", 4000000},
        {"Chicago", 3000000},
        {"Houston", 2000000},
        {"Philadelphia", 1000000}
    };
    int num_cities = sizeof(cities) / sizeof(city);

    // Print the database of people
    printf("People:\n");
    for (int i = 0; i < num_people; i++) {
        printf("%s, %d\n", people[i].name, people[i].age);
    }

    // Print the database of cities
    printf("\nCities:\n");
    for (int i = 0; i < num_cities; i++) {
        printf("%s, %d\n", cities[i].name, cities[i].population);
    }

    // Find the oldest person in the database
    int oldest_age = 0;
    char *oldest_name = NULL;
    for (int i = 0; i < num_people; i++) {
        if (people[i].age > oldest_age) {
            oldest_age = people[i].age;
            oldest_name = people[i].name;
        }
    }

    // Print the oldest person
    printf("\nOldest person:\n");
    printf("%s, %d\n", oldest_name, oldest_age);

    // Find the most populous city in the database
    int largest_population = 0;
    char *largest_city = NULL;
    for (int i = 0; i < num_cities; i++) {
        if (cities[i].population > largest_population) {
            largest_population = cities[i].population;
            largest_city = cities[i].name;
        }
    }

    // Print the most populous city
    printf("\nMost populous city:\n");
    printf("%s, %d\n", largest_city, largest_population);

    return 0;
}