//GEMINI-pro DATASET v1.0 Category: Warehouse Management System ; Style: calm
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of products and warehouses
#define MAX_PRODUCTS 100
#define MAX_WAREHOUSES 10

// Define the product structure
typedef struct {
    int id;
    char name[50];
    int quantity;
    float price;
} Product;

// Define the warehouse structure
typedef struct {
    int id;
    char name[50];
    Product products[MAX_PRODUCTS];
    int num_products;
} Warehouse;

// Initialize the products and warehouses
Product products[MAX_PRODUCTS];
Warehouse warehouses[MAX_WAREHOUSES];
int num_products = 0;
int num_warehouses = 0;

// Function to add a product
void add_product(Product product) {
    // Check if the product already exists
    for (int i = 0; i < num_products; i++) {
        if (products[i].id == product.id) {
            printf("Product already exists\n");
            return;
        }
    }

    // Add the product to the array
    products[num_products] = product;
    num_products++;
}

// Function to add a warehouse
void add_warehouse(Warehouse warehouse) {
    // Check if the warehouse already exists
    for (int i = 0; i < num_warehouses; i++) {
        if (warehouses[i].id == warehouse.id) {
            printf("Warehouse already exists\n");
            return;
        }
    }

    // Add the warehouse to the array
    warehouses[num_warehouses] = warehouse;
    num_warehouses++;
}

// Function to print the products
void print_products() {
    printf("Products:\n");
    for (int i = 0; i < num_products; i++) {
        printf("%d %s %d %.2f\n", products[i].id, products[i].name, products[i].quantity, products[i].price);
    }
}

// Function to print the warehouses
void print_warehouses() {
    printf("Warehouses:\n");
    for (int i = 0; i < num_warehouses; i++) {
        printf("%d %s\n", warehouses[i].id, warehouses[i].name);
        for (int j = 0; j < warehouses[i].num_products; j++) {
            printf("  %d %s %d %.2f\n", warehouses[i].products[j].id, warehouses[i].products[j].name, warehouses[i].products[j].quantity, warehouses[i].products[j].price);
        }
    }
}

// Main function
int main() {
    // Add some products
    Product product1 = {1, "Product 1", 10, 10.0};
    Product product2 = {2, "Product 2", 20, 20.0};
    Product product3 = {3, "Product 3", 30, 30.0};
    add_product(product1);
    add_product(product2);
    add_product(product3);

    // Add some warehouses
    Warehouse warehouse1 = {1, "Warehouse 1"};
    Warehouse warehouse2 = {2, "Warehouse 2"};
    add_warehouse(warehouse1);
    add_warehouse(warehouse2);

    // Add some products to the warehouses
    warehouse1.products[0] = product1;
    warehouse1.num_products++;
    warehouse1.products[1] = product2;
    warehouse1.num_products++;
    warehouse2.products[0] = product3;
    warehouse2.num_products++;

    // Print the products and warehouses
    print_products();
    print_warehouses();

    return 0;
}