//MISTRAL-7B DATASET v1.0 Category: Checksum Calculator ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_LEN 1000

typedef struct {
    int love_letters[26];
    int romantic_numbers[10];
} romantic_checksum;

void initialize_checksum(romantic_checksum *checksum) {
    int i;

    for (i = 0; i < 26; i++) {
        checksum->love_letters[i] = i + 'A' - 'A';
    }

    for (i = 0; i < 10; i++) {
        checksum->romantic_numbers[i] = i;
    }
}

int calculate_romantic_checksum(const char *data, romantic_checksum *checksum) {
    int i, j, sum = 0, temp;
    char *ptr = (char *) data;

    for (i = 0; i < strlen(data) && i < MAX_LEN; i++) {
        if (isalpha(*ptr)) {
            sum += checksum->love_letters[toupper(*ptr) - 'A'];
        } else if (isdigit(*ptr)) {
            sum += checksum->romantic_numbers[*ptr - '0'];
        }
        ptr++;
    }

    for (i = 0; i < 26; i++) {
        j = sum % 26;
        temp = checksum->love_letters[i];
        checksum->love_letters[i] = checksum->love_letters[j];
        checksum->love_letters[j] = temp;
        sum = (sum - checksum->love_letters[i] + 26) % 26;
    }

    for (i = 0; i < 10; i++) {
        j = sum % 10;
        temp = checksum->romantic_numbers[i];
        checksum->romantic_numbers[i] = checksum->romantic_numbers[j];
        checksum->romantic_numbers[j] = temp;
        sum = (sum - checksum->romantic_numbers[i] + 10) % 10;
    }

    return sum;
}

int main() {
    romantic_checksum checksum;
    char data[MAX_LEN] = "Roses are red, violets are blue,\nYour love is like a melody, so sweet and true.";
    int checksum_value;

    initialize_checksum(&checksum);
    checksum_value = calculate_romantic_checksum(data, &checksum);

    printf("Your romantic checksum is: %d\n", checksum_value);

    return 0;
}