//GEMINI-pro DATASET v1.0 Category: Data mining ; Style: energetic
// Dive into the enigmatic realm of data mining with this spirited C escapade!

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Our adventurous explorers for data discovery
typedef struct {
    int id;
    char *name;
    double score;
} Adventurer;

// A vibrant collection of intrepid souls
Adventurer adventurers[] = {
    {1, "Artemis", 85.2},
    {2, "Orion", 92.7},
    {3, "Perseus", 78.4},
    {4, "Andromeda", 90.9},
    {5, "Cassiopeia", 82.1}
};

// The beacon guiding our search: a comparison function
int compareAdventurers(const void *a, const void *b) {
    Adventurer *a1 = (Adventurer *)a;
    Adventurer *a2 = (Adventurer *)b;
    return a1->score > a2->score ? -1 : (a1->score < a2->score ? 1 : 0);
}

// Let's unravel the secrets of their abilities!
void dataMine(Adventurer *adventurers, int size) {
    // Rank the adventurers in descending order of their prowess
    qsort(adventurers, size, sizeof(Adventurer), compareAdventurers);

    // Reveal the top-scoring adventurers
    printf("Behold, the mightiest adventurers:\n");
    for (int i = 0; i < 3; i++) {
        printf("%s (Score: %.2f)\n", adventurers[i].name, adventurers[i].score);
    }

    // Uncover the average score across all adventurers
    double totalScore = 0;
    for (int i = 0; i < size; i++) {
        totalScore += adventurers[i].score;
    }
    printf("\nOn average, our adventurers have scaled to a score of: %.2f\n", totalScore / size);

    // Classify the adventurers into skill tiers (Expert, Skilled, Novice)
    for (int i = 0; i < size; i++) {
        if (adventurers[i].score >= 90) {
            adventurers[i].name = realloc(adventurers[i].name, strlen("Expert") + 1);
            strcpy(adventurers[i].name, "Expert");
        } else if (adventurers[i].score >= 80) {
            adventurers[i].name = realloc(adventurers[i].name, strlen("Skilled") + 1);
            strcpy(adventurers[i].name, "Skilled");
        } else {
            adventurers[i].name = realloc(adventurers[i].name, strlen("Novice") + 1);
            strcpy(adventurers[i].name, "Novice");
        }
    }

    // Display the adventurers grouped by their skill tiers
    printf("\nSkill Tiers:\n");
    for (int i = 0; i < size; i++) {
        printf("%s: %s\n", adventurers[i].name, adventurers[i].name);
    }
}

int main() {
    // Embark on our data mining expedition
    dataMine(adventurers, sizeof(adventurers) / sizeof(adventurers[0]));

    // Farewell, intrepid data miners!
    return 0;
}