//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NODES 100
#define MAX_LINKS 1000
#define LINK_COST_MAX 9999

typedef struct Node {
    char name[10];
    int id;
    int x, y;
} Node;

typedef struct Link {
    int from_node_id;
    int to_node_id;
    int cost;
} Link;

Node nodes[MAX_NODES];
Link links[MAX_LINKS];
int num_nodes = 0;
int num_links = 0;

void add_node(char* name, int id, int x, int y) {
    if (num_nodes >= MAX_NODES) {
        printf("Error: Maximum number of nodes reached.\n");
        return;
    }
    strcpy(nodes[num_nodes].name, name);
    nodes[num_nodes].id = id;
    nodes[num_nodes].x = x;
    nodes[num_nodes].y = y;
    num_nodes++;
}

void add_link(int from_node_id, int to_node_id, int cost) {
    if (num_links >= MAX_LINKS) {
        printf("Error: Maximum number of links reached.\n");
        return;
    }
    links[num_links].from_node_id = from_node_id;
    links[num_links].to_node_id = to_node_id;
    links[num_links].cost = cost;
    num_links++;
}

void print_nodes() {
    printf("Nodes:\n");
    for (int i = 0; i < num_nodes; i++) {
        printf("%d: %s (%d, %d)\n", i, nodes[i].name, nodes[i].x, nodes[i].y);
    }
}

void print_links() {
    printf("Links:\n");
    for (int i = 0; i < num_links; i++) {
        printf("%d -> %d (%d)\n", links[i].from_node_id, links[i].to_node_id, links[i].cost);
    }
}

int main() {
    add_node("Node 1", 1, 0, 0);
    add_node("Node 2", 2, 10, 0);
    add_node("Node 3", 3, 20, 0);
    add_node("Node 4", 4, 30, 0);
    add_link(1, 2, 5);
    add_link(2, 3, 7);
    add_link(3, 4, 9);
    print_nodes();
    print_links();
    return 0;
}