//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: funny
#include <stdio.h>
#include <string.h>

// Define the maximum number of items that can be ordered
#define MAX_ITEMS 10

// Define the structure of an item
typedef struct item {
    char name[20];
    int price;
    int quantity;
} item_t;

// Create an array of items
item_t items[MAX_ITEMS];

// Function to add an item to the array
void add_item(char *name, int price, int quantity) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            strcpy(items[i].name, name);
            items[i].price = price;
            items[i].quantity = quantity;
            return;
        }
    }

    // If the array is full, print an error message
    printf("Error: The array of items is full.\n");
}

// Function to calculate the total cost of an order
int calculate_total_cost(int num_items) {
    int total_cost = 0;

    for (int i = 0; i < num_items; i++) {
        total_cost += items[i].price * items[i].quantity;
    }

    return total_cost;
}

// Function to print the order
void print_order(int num_items) {
    printf("Order:\n");

    for (int i = 0; i < num_items; i++) {
        printf("%s: %d pieces @ %d dollars = %d dollars\n", items[i].name, items[i].quantity, items[i].price, items[i].price * items[i].quantity);
    }

    printf("Total cost: %d dollars\n", calculate_total_cost(num_items));
}

int main() {
    // Add some items to the array
    add_item("Coffee", 2, 3);
    add_item("Tea", 1, 2);
    add_item("Juice", 1.5, 1);

    // Print the order
    print_order(3);

    return 0;
}