//GEMINI-pro DATASET v1.0 Category: Building a HTTP Client ; Style: innovative
// Let's cook up some HTTP magic with a dash of style!

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

// Our very own HTTP ninja arsenal
typedef struct {
    char *url;
    char *buffer;
    size_t size;
} HTTPResponse;

// Time to fetch some data!
size_t receive_response(char *ptr, size_t size, size_t nmemb, void *stream) {
    HTTPResponse *response = (HTTPResponse *)stream;
    size_t bytes = size * nmemb;
    response->buffer = realloc(response->buffer, response->size + bytes + 1);
    if (response->buffer == NULL) return 0;
    memcpy(response->buffer + response->size, ptr, bytes);
    response->size += bytes;
    response->buffer[response->size] = '\0';
    return bytes;
}

// Let's fire up the HTTP client
CURLcode http_get(HTTPResponse *response, const char *url) {
    CURL *curl = curl_easy_init();
    if (!curl) return CURLE_FAILED_INIT;

    curl_easy_setopt(curl, CURLOPT_URL, url);
    curl_easy_setopt(curl, CURLOPT_WRITEDATA, response);
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, receive_response);

    CURLcode result = curl_easy_perform(curl);
    curl_easy_cleanup(curl);
    return result;
}

// Display the HTTP response
void print_response(const HTTPResponse *response) {
    printf("\nHTTP Response:\n\n%s\n\n", response->buffer);
}

// A spicy example to savor
int main() {
    // Let's explore the vastness of Stack Overflow
    char *url = "https://stackoverflow.com/questions/tagged/c";
    HTTPResponse response = { url, NULL, 0 };

    // Time to fetch the data
    CURLcode result = http_get(&response, url);

    // Let's check if our request was successful
    if (result != CURLE_OK) {
        printf("HTTP request failed: %s\n", curl_easy_strerror(result));
        return EXIT_FAILURE;
    }

    // Feast our eyes on the HTML feast
    print_response(&response);

    // Free the memory
    free(response.buffer);

    return EXIT_SUCCESS;
}