//Falcon-180B DATASET v1.0 Category: Time Travel Simulator ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_YEAR 9999
#define MIN_YEAR 1900

struct date {
    int year;
    int month;
    int day;
};

struct date current_date = {.year = 2021,.month = 8,.day = 15};

void print_date(struct date date) {
    printf("%d-%d-%d\n", date.year, date.month, date.day);
}

int main() {
    srand(time(NULL));
    int year = rand() % (MAX_YEAR - MIN_YEAR + 1) + MIN_YEAR;
    int month = rand() % 12 + 1;
    int day = rand() % 28 + 1;
    struct date target_date = {.year = year,.month = month,.day = day};

    printf("Current date: ");
    print_date(current_date);
    printf("Target date: ");
    print_date(target_date);

    int direction = rand() % 2;
    if (direction == 0) {
        printf("Traveling back in time...\n");
    } else {
        printf("Traveling forward in time...\n");
    }

    if (direction == 0) {
        if (target_date.year < current_date.year) {
            printf("You cannot travel back to a year before your current year.\n");
            return 1;
        }
    } else if (direction == 1) {
        if (target_date.year > current_date.year) {
            printf("You cannot travel forward to a year after your current year.\n");
            return 1;
        }
    }

    if (direction == 0) {
        if (target_date.month < current_date.month) {
            printf("You cannot travel back to a month before your current month.\n");
            return 1;
        }
    } else if (direction == 1) {
        if (target_date.month > current_date.month) {
            printf("You cannot travel forward to a month after your current month.\n");
            return 1;
        }
    }

    if (direction == 0) {
        if (target_date.day < current_date.day) {
            printf("You cannot travel back to a day before your current day.\n");
            return 1;
        }
    } else if (direction == 1) {
        if (target_date.day > current_date.day) {
            printf("You cannot travel forward to a day after your current day.\n");
            return 1;
        }
    }

    printf("Time travel successful!\n");
    return 0;
}