//Falcon2-11B DATASET v1.0 Category: Network Ping Test ; Style: peaceful
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

int main() {
    int sockfd, valread, portno, n;
    struct sockaddr_in serv_addr;
    char buffer[1000];

    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("ERROR opening socket");
        exit(1);
    }

    bzero((char *) &serv_addr, sizeof(serv_addr));
    portno = 80;
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(portno);

    if (inet_pton(AF_INET, "127.0.0.1", &serv_addr.sin_addr) <= 0) {
        perror("ERROR, could not resolve hostname");
        exit(1);
    }

    if (connect(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0) {
        perror("ERROR connecting");
        exit(1);
    }

    printf("Pinging %s...\n", inet_ntoa(serv_addr.sin_addr));

    valread = send(sockfd, "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n", 54, 0);
    if (valread < 0) {
        perror("ERROR writing to socket");
        exit(1);
    }

    valread = recv(sockfd, buffer, 1000, 0);
    if (valread < 0) {
        perror("ERROR reading from socket");
        exit(1);
    }

    printf("Response: %s\n", buffer);

    close(sockfd);

    return 0;
}