//Falcon-180B DATASET v1.0 Category: Packet Capturer with pcap library ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <string.h>

#define MAX_SNAPLEN 65536
#define MAX_PACKETS 1024

typedef struct {
    u_char *data;
    int len;
} packet_t;

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    packet_t *pkt = (packet_t *) args;
    pkt->len = header->len;
    pkt->data = malloc(header->len);
    if (pkt->data == NULL) {
        printf("Error allocating memory\n");
        exit(1);
    }
    memcpy(pkt->data, packet, header->len);
}

int main() {
    char *dev = "eth0";
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    packet_t packets[MAX_PACKETS];
    int num_packets = 0;
    int i;

    handle = pcap_open_live(dev, BUFSIZ, 1, 1000, errbuf);
    if (handle == NULL) {
        printf("Error opening device: %s\n", errbuf);
        exit(1);
    }

    printf("Capturing packets...\n");
    pcap_loop(handle, -1, packet_handler, (u_char *) packets);

    for (i = 0; i < num_packets; i++) {
        printf("Packet %d:\n", i);
        printf("Length: %d\n", packets[i].len);
        printf("Data:");
        int j;
        for (j = 0; j < packets[i].len; j++) {
            printf("%02X ", packets[i].data[j]);
        }
        printf("\n");
    }

    pcap_close(handle);
    return 0;
}