//GPT-4o-mini DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: asynchronous
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>
#include <time.h>

#define MAX_PROCESSES 5
#define TIME_QUANTUM 2

typedef struct {
    int id;
    int burst_time;
    int remaining_time;
} Process;

typedef struct {
    Process processes[MAX_PROCESSES];
    int process_count;
    int current_index;
} Scheduler;

Scheduler scheduler;

void initialize_scheduler() {
    scheduler.process_count = MAX_PROCESSES;
    scheduler.current_index = 0;

    for (int i = 0; i < MAX_PROCESSES; i++) {
        scheduler.processes[i].id = i + 1;
        scheduler.processes[i].burst_time = rand() % 5 + 1;  // Burst time between 1 to 5
        scheduler.processes[i].remaining_time = scheduler.processes[i].burst_time;
    }
}

void execute_process(Process *process) {
    int execution_time = (process->remaining_time < TIME_QUANTUM) ? process->remaining_time : TIME_QUANTUM;
    printf("Executing Process %d for %d time units.\n", process->id, execution_time);
    sleep(execution_time); // Simulate process execution
    process->remaining_time -= execution_time;

    if (process->remaining_time == 0) {
        printf("Process %d completed.\n", process->id);
    }
}

void* round_robin_scheduling(void* arg) {
    while (1) {
        Process* process = &scheduler.processes[scheduler.current_index];
        
        if (process->remaining_time > 0) {
            execute_process(process);
        }
        
        // Move to the next process
        scheduler.current_index = (scheduler.current_index + 1) % MAX_PROCESSES;

        // Check if all processes are complete
        int all_done = 1;
        for (int i = 0; i < MAX_PROCESSES; i++) {
            if (scheduler.processes[i].remaining_time > 0) {
                all_done = 0;
                break;
            }
        }
        if (all_done) {
            break;
        }
    }
    
    return NULL;
}

int main() {
    srand(time(NULL)); // Seed the random number generator

    initialize_scheduler();

    printf("Starting Round Robin CPU Scheduling with Time Quantum of %d units.\n", TIME_QUANTUM);

    pthread_t scheduler_thread;
    pthread_create(&scheduler_thread, NULL, round_robin_scheduling, NULL);
    
    pthread_join(scheduler_thread, NULL); // Wait for the scheduler to complete

    printf("All processes have been executed.\n");
    return 0;
}