//MISTRAL-7B DATASET v1.0 Category: Warehouse Management System ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#define MAX_PRODUCTS 50
#define MAX_QUANTITY 1000

typedef struct {
    char product_name[50];
    int stock;
} Product;

Product inventory[MAX_PRODUCTS];

void initialize_inventory() {
    for (int i = 0; i < MAX_PRODUCTS; i++) {
        strcpy(inventory[i].product_name, "Unnamed Product");
        inventory[i].stock = 0;
    }
}

void add_product(char *product_name, int initial_stock) {
    for (int i = 0; i < MAX_PRODUCTS; i++) {
        if (inventory[i].stock == 0 && strcmp(inventory[i].product_name, product_name) != 0) {
            strcpy(inventory[i].product_name, product_name);
            inventory[i].stock = initial_stock;
            break;
        }
    }
}

void update_stock(char *product_name, int quantity) {
    for (int i = 0; i < MAX_PRODUCTS; i++) {
        if (strcmp(inventory[i].product_name, product_name) == 0) {
            inventory[i].stock += quantity;
            break;
        }
    }
}

int main() {
    initialize_inventory();

    add_product("Apple", 100);
    add_product("Banana", 50);
    add_product("Orange", 75);

    update_stock("Apple", 25);

    printf("Product Name\tStock\n");
    for (int i = 0; i < MAX_PRODUCTS; i++) {
        printf("%s\t%d\n", inventory[i].product_name, inventory[i].stock);
    }

    return 0;
}