//Falcon2-11B DATASET v1.0 Category: Game of Life ; Style: configurable
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#define ROWS 10
#define COLS 10
#define LIVE 1
#define DEAD 0
int main(int argc, char *argv[]) {
    srand(time(NULL)); // Seed the random number generator
    int grid[ROWS][COLS]; // Initialize a 2D array to hold the grid
    for (int i = 0; i < ROWS; i++) {
        for (int j = 0; j < COLS; j++) {
            grid[i][j] = DEAD; // Initialize all cells to dead
        }
    }
    for (int i = 0; i < ROWS; i++) {
        for (int j = 0; j < COLS; j++) {
            printf("(%d,%d) ", i, j);
            if (grid[i][j] == LIVE) {
                printf("live\n");
            } else {
                printf("dead\n");
            }
        }
        printf("\n");
    }
    printf("\nNext generation:\n");
    for (int i = 0; i < ROWS; i++) {
        for (int j = 0; j < COLS; j++) {
            printf("(%d,%d) ", i, j);
            int liveNeighbors = 0;
            for (int x = -1; x < 2; x++) {
                for (int y = -1; y < 2; y++) {
                    int neighborX = i + x;
                    int neighborY = j + y;
                    if (neighborX >= 0 && neighborX < ROWS && neighborY >= 0 && neighborY < COLS) {
                        if (grid[neighborX][neighborY] == LIVE) {
                            liveNeighbors++;
                        }
                    }
                }
            }
            if (grid[i][j] == LIVE && (liveNeighbors < 2 || liveNeighbors > 3)) {
                grid[i][j] = DEAD;
            } else if (grid[i][j] == DEAD && liveNeighbors == 3) {
                grid[i][j] = LIVE;
            }
            printf("%d\n", grid[i][j]);
        }
        printf("\n");
    }
    return 0;
}