//Falcon2-11B DATASET v1.0 Category: Interprocess communication ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

int main() {
  int sockfd, portno, newsockfd, valread;
  struct sockaddr_in serv_addr, cli_addr;
  char buf[256];

  // Creating socket file descriptor
  if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
    perror("socket failed");
    exit(EXIT_FAILURE);
  }

  // Assigning local host name to serv_addr structure
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = INADDR_ANY;
  serv_addr.sin_port = htons(portno);

  // Binding the socket to local host and port
  if (bind(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
    perror("bind failed");
    exit(EXIT_FAILURE);
  }

  // Starting to listen for incoming connections
  if (listen(sockfd, 3) < 0) {
    perror("listen");
    exit(EXIT_FAILURE);
  }

  // Accepting the incoming connection
  newsockfd = accept(sockfd, (struct sockaddr *)&cli_addr, &valread);
  if (newsockfd < 0) {
    perror("accept");
    exit(EXIT_FAILURE);
  }

  // Reading the message from client
  read(newsockfd, buf, 256);
  printf("Received message from client: %s\n", buf);

  // Sending the message back to the client
  write(newsockfd, "Message received and sent back", 29);

  // Closing the socket
  close(newsockfd);
  close(sockfd);
  return 0;
}