//Falcon-180B DATASET v1.0 Category: Movie Rating System ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_MOVIES 100
#define MAX_RATINGS 5

struct movie {
    char title[100];
    int year;
    float rating;
    int num_ratings;
};

void add_movie(struct movie* movies, int num_movies, char* title, int year, float rating) {
    int i;
    for (i = 0; i < num_movies; i++) {
        if (strcmp(movies[i].title, title) == 0) {
            movies[i].year = year;
            movies[i].rating = rating;
            movies[i].num_ratings = 1;
            return;
        }
    }
    if (num_movies >= MAX_MOVIES) {
        printf("Error: Maximum number of movies reached.\n");
        exit(1);
    }
    strcpy(movies[num_movies].title, title);
    movies[num_movies].year = year;
    movies[num_movies].rating = rating;
    movies[num_movies].num_ratings = 1;
    num_movies++;
}

void print_movies(struct movie* movies, int num_movies) {
    int i;
    for (i = 0; i < num_movies; i++) {
        printf("%s (%d) - %.2f (%d ratings)\n", movies[i].title, movies[i].year, movies[i].rating, movies[i].num_ratings);
    }
}

void rate_movie(struct movie* movies, int num_movies, char* title) {
    int i;
    for (i = 0; i < num_movies; i++) {
        if (strcmp(movies[i].title, title) == 0) {
            movies[i].rating += 0.1;
            movies[i].num_ratings++;
            printf("%s rated %.2f (%d ratings)\n", title, movies[i].rating, movies[i].num_ratings);
            return;
        }
    }
    printf("%s not found.\n", title);
}

int main() {
    struct movie movies[MAX_MOVIES];
    int num_movies = 0;

    add_movie(movies, num_movies, "The Godfather", 1972, 9.2);
    add_movie(movies, num_movies, "The Shawshank Redemption", 1994, 9.3);
    add_movie(movies, num_movies, "The Dark Knight", 2008, 9.0);

    print_movies(movies, num_movies);

    rate_movie(movies, num_movies, "The Godfather");
    rate_movie(movies, num_movies, "The Shawshank Redemption");

    print_movies(movies, num_movies);

    return 0;
}