//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: shocked
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define MAX_NODES 1000
#define MAX_EDGES 10000

typedef struct {
    int id;
    char name[20];
    int x, y;
} Node;

typedef struct {
    int src, dest;
    int weight;
} Edge;

Node nodes[MAX_NODES];
Edge edges[MAX_EDGES];

int num_nodes, num_edges;

int find_node(char *name) {
    int i;
    for (i = 0; i < num_nodes; i++) {
        if (strcmp(nodes[i].name, name) == 0) {
            return i;
        }
    }
    return -1;
}

void add_node(char *name, int x, int y) {
    int id;
    if (num_nodes >= MAX_NODES) {
        printf("Too many nodes!\n");
        exit(1);
    }
    id = num_nodes;
    strcpy(nodes[id].name, name);
    nodes[id].x = x;
    nodes[id].y = y;
    num_nodes++;
}

void add_edge(char *src_name, char *dest_name, int weight) {
    int src, dest;
    src = find_node(src_name);
    dest = find_node(dest_name);
    if (src == -1 || dest == -1) {
        printf("Invalid node name!\n");
        exit(1);
    }
    if (num_edges >= MAX_EDGES) {
        printf("Too many edges!\n");
        exit(1);
    }
    edges[num_edges].src = src;
    edges[num_edges].dest = dest;
    edges[num_edges].weight = weight;
    num_edges++;
}

void print_nodes() {
    int i;
    for (i = 0; i < num_nodes; i++) {
        printf("%d: %s (%d, %d)\n", i, nodes[i].name, nodes[i].x, nodes[i].y);
    }
}

void print_edges() {
    int i;
    for (i = 0; i < num_edges; i++) {
        printf("%d -> %d (%d)\n", edges[i].src, edges[i].dest, edges[i].weight);
    }
}

int main() {
    add_node("A", 0, 0);
    add_node("B", 1, 0);
    add_node("C", 2, 0);
    add_node("D", 3, 0);
    add_edge("A", "B", 1);
    add_edge("B", "C", 2);
    add_edge("C", "D", 3);
    print_nodes();
    print_edges();
    return 0;
}