//Gemma-7B DATASET v1.0 Category: Interprocess communication ; Style: post-apocalyptic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/ipc.h>
#include <sys/msg.h>

#define MSG_QUEUE_NAME "my_msg_queue"
#define MESSAGE_SIZE 1024

typedef struct Message {
  char sender[20];
  char recipient[20];
  char message[MESSAGE_SIZE];
} Message;

int main()
{
  int msg_id;
  Message message;

  // Create a message queue
  msg_id = msgget(IPC_PRIVATE, IPC_CREAT | IPC_EXCL);
  if (msg_id == -1)
  {
    perror("Error creating message queue");
    exit(1);
  }

  // Prepare the message
  strcpy(message.sender, "John Doe");
  strcpy(message.recipient, "Jane Doe");
  strcpy(message.message, "Hello, Jane. This is John.");

  // Send the message
  msgsnd(msg_id, &message, sizeof(Message), 0);

  // Receive the message
  message.recipient[0] = '\0';
  msgrcv(msg_id, &message, sizeof(Message), 0, 0);

  // Print the message
  printf("Received message from: %s\n", message.sender);
  printf("Message: %s\n", message.message);

  // Destroy the message queue
  msgctl(msg_id, IPC_RMID, NULL);

  return 0;
}