//GEMINI-pro DATASET v1.0 Category: Fitness Tracker ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the maximum number of steps and heart rate measurements
#define MAX_STEPS 10000
#define MAX_HEART_RATE 220

// Define the names of the two lovers
#define LOVER1 "Romeo"
#define LOVER2 "Juliet"

// Define the colors for each lover
#define LOVER1_COLOR "\x1B[31m"
#define LOVER2_COLOR "\x1B[32m"

// Define the reset color code
#define RESET_COLOR "\x1B[0m"

// Function to generate a random number between two values
int random_number(int min, int max) {
    return rand() % (max - min + 1) + min;
}

// Function to generate a random step count
int generate_steps() {
    return random_number(0, MAX_STEPS);
}

// Function to generate a random heart rate
int generate_heart_rate() {
    return random_number(60, MAX_HEART_RATE);
}

// Function to print a heart
void print_heart() {
    printf("  .-""`""-. \n /        \\   \n;  #        :  \n |           |  \n  \         /   \n   `-..___..-'");
}

// Function to print a step
void print_step() {
    printf("  .-~~\\         /~~-.  ");
    printf("\./     \\__..__/     \\.");
    printf("\ \          ::          / ");
    printf("  \\         ::         /  ");
    printf("   \        ::        /   ");
    printf("    \\      ::      /    ");
    printf("     \\    ::    /     ");
    printf("      \  ::  /      ");
    printf("       `\/\/`       ");
}

// Function to print the fitness tracker data
void print_fitness_tracker_data(int steps, int heart_rate) {
    printf("\n\n");
    printf("  ------------------------------------------------------  \n");
    printf(" | " LOVER1_COLOR "%s's" RESET_COLOR " Fitness Tracker Data | " LOVER2_COLOR "%s's" RESET_COLOR " Fitness Tracker Data |\n", LOVER1, LOVER2);
    printf("  ------------------------------------------------------  \n");
    printf(" | Steps: %d | Steps: %d |\n", steps, steps);
    printf(" | Heart Rate: %d | Heart Rate: %d |\n", heart_rate, heart_rate);
    printf("  ------------------------------------------------------  \n");
    printf("\n\n");
}

// Function to print a romantic message
void print_romantic_message() {
    printf("\n");
    printf(LOVER1_COLOR "%s" RESET_COLOR " and " LOVER2_COLOR "%s" RESET_COLOR ", you are both doing amazing!\n", LOVER1, LOVER2);
    printf("Keep up the good work and stay healthy for each other.\n");
    printf("\n");
}

// Main function
int main() {
    // Seed the random number generator
    srand(time(NULL));

    // Generate random step and heart rate data for each lover
    int lover1_steps = generate_steps();
    int lover1_heart_rate = generate_heart_rate();
    int lover2_steps = generate_steps();
    int lover2_heart_rate = generate_heart_rate();

    // Print the fitness tracker data
    print_fitness_tracker_data(lover1_steps, lover1_heart_rate);

    // Print a heart between the two fitness trackers
    print_heart();

    // Print the fitness tracker data for the second lover
    print_fitness_tracker_data(lover2_steps, lover2_heart_rate);

    // Print a romantic message
    print_romantic_message();

    return 0;
}