//LLAMA2-13B DATASET v1.0 Category: Sorting ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define ARRAY_SIZE 10

// Function to swap two elements in an array
void swap(int arr[], int i, int j) {
    int temp = arr[i];
    arr[i] = arr[j];
    arr[j] = temp;
}

// Function to sort the array using insertion sort
void insertionSort(int arr[], int left, int right) {
    int i, j;

    for (i = left + 1; i <= right; i++) {
        // Find the right position for the current element
        for (j = left; j > i - 1 && arr[j] > arr[i]; j--) {
            swap(arr, j, j + 1);
        }
        swap(arr, j, i);
    }
}

int main() {
    // Generate a random array of integers
    srand(time(NULL));
    int arr[ARRAY_SIZE] = {0};
    for (int i = 0; i < ARRAY_SIZE; i++) {
        arr[i] = rand() % 100;
    }

    // Print the original array
    printf("Original array: ");
    for (int i = 0; i < ARRAY_SIZE; i++) {
        printf("%d ", arr[i]);
    }
    printf("\n");

    // Sort the array using insertion sort
    insertionSort(arr, 0, ARRAY_SIZE - 1);

    // Print the sorted array
    printf("Sorted array: ");
    for (int i = 0; i < ARRAY_SIZE; i++) {
        printf("%d ", arr[i]);
    }
    printf("\n");

    return 0;
}