//LLAMA2-13B DATASET v1.0 Category: Weather simulation ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define MAX_TEMP 40
#define MIN_TEMP 0
#define MAX_HUM 100
#define MIN_HUM 20
#define DAY_LENGTH 24

typedef struct {
    int temperature;
    int humidity;
} weather_data_t;

weather_data_t current_weather;
weather_data_t previous_weather;

void set_weather(int temperature, int humidity) {
    current_weather.temperature = temperature;
    current_weather.humidity = humidity;
}

void print_weather() {
    printf("Current Weather: \n");
    printf("Temperature: %d\n", current_weather.temperature);
    printf("Humidity: %d\n", current_weather.humidity);
}

void update_weather() {
    srand(time(NULL));
    int temperature_change = rand() % 10 - 5;
    int humidity_change = rand() % 10 - 5;
    current_weather.temperature += temperature_change;
    current_weather.humidity += humidity_change;
    if (current_weather.temperature < MIN_TEMP) {
        current_weather.temperature = MIN_TEMP;
    } else if (current_weather.temperature > MAX_TEMP) {
        current_weather.temperature = MAX_TEMP;
    }
    if (current_weather.humidity < MIN_HUM) {
        current_weather.humidity = MIN_HUM;
    } else if (current_weather.humidity > MAX_HUM) {
        current_weather.humidity = MAX_HUM;
    }
}

int main() {
    set_weather(22, 60);
    print_weather();
    update_weather();
    print_weather();
    for (int i = 0; i < DAY_LENGTH; i++) {
        update_weather();
        print_weather();
    }
    return 0;
}