//MISTRAL-7B DATASET v1.0 Category: Haunted House Simulator ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <string.h>

#define NUM_ROOMS 3

typedef struct {
    char name[20];
    int has_creaky_floor;
    int has_swinging_door;
    int has_ghost;
    int ghost_chance;
} Room;

void simulate_room_entry(Room *room) {
    if (room->has_creaky_floor) {
        printf("You hear a loud creak as you enter the room.\n");
    }

    if (room->has_swinging_door) {
        printf("The door swings open slowly, revealing the room.\n");
    }

    if (room->has_ghost && rand() % room->ghost_chance == 0) {
        printf("A ghost appears in front of you!\n");
    } else {
        printf("The room is empty.\n");
    }
}

int main() {
    srand(time(NULL));
    Room rooms[NUM_ROOMS];

    strcpy(rooms[0].name, "Room of Whispers");
    rooms[0].has_creaky_floor = 1;
    rooms[0].has_swinging_door = 0;
    rooms[0].has_ghost = 1;
    rooms[0].ghost_chance = 50;

    strcpy(rooms[1].name, "Room of Echoes");
    rooms[1].has_creaky_floor = 0;
    rooms[1].has_swinging_door = 1;
    rooms[1].has_ghost = 0;

    strcpy(rooms[2].name, "Room of Shadows");
    rooms[2].has_creaky_floor = 1;
    rooms[2].has_swinging_door = 0;
    rooms[2].has_ghost = 1;
    rooms[2].ghost_chance = 25;

    for (int i = 0; i < NUM_ROOMS; i++) {
        printf("\n=====================\n");
        printf("Entering %s...\n", rooms[i].name);
        simulate_room_entry(&rooms[i]);
    }

    return 0;
}