//Falcon-180B DATASET v1.0 Category: Percolation Simulator ; Style: satisfied
// This is a C Percolation Simulator example program that simulates the flow of water through a 2D grid of cells.

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define ROWS 20
#define COLS 30

int grid[ROWS][COLS]; // The 2D grid of cells
int num_open = 0; // The number of open cells

void init_grid() {
    for (int i = 0; i < ROWS; i++) {
        for (int j = 0; j < COLS; j++) {
            grid[i][j] = -1; // -1 represents a closed cell
        }
    }
}

void open_cell(int row, int col) {
    grid[row][col] = 0; // 0 represents an open cell
    num_open++;
}

int is_valid(int row, int col) {
    if (row >= 0 && row < ROWS && col >= 0 && col < COLS) {
        return 1;
    }
    return 0;
}

void percolate() {
    int row, col;
    for (int i = 0; i < num_open; i++) {
        row = rand() % ROWS;
        col = rand() % COLS;
        while (!is_valid(row, col)) {
            row = rand() % ROWS;
            col = rand() % COLS;
        }
        open_cell(row, col);
    }
}

void print_grid() {
    for (int i = 0; i < ROWS; i++) {
        for (int j = 0; j < COLS; j++) {
            if (grid[i][j] == -1) {
                printf("X ");
            } else {
                printf("O ");
            }
        }
        printf("\n");
    }
}

int main() {
    srand(time(NULL));
    init_grid();
    percolate();
    print_grid();
    return 0;
}