//Gemma-7B DATASET v1.0 Category: Simple Web Server ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <sys/socket.h>

#define SERVER_PORT 8080
#define BUFFER_SIZE 1024

int main() {
    int sockfd, newsockfd, port, clientlen, read_size, write_size;
    char buffer[BUFFER_SIZE];

    // Create a socket
    sockfd = socket(AF_INET, SOCK_STREAM, htons(SERVER_PORT));
    if (sockfd < 0) {
        perror("Error creating socket");
        exit(1);
    }

    // Bind the socket to a port
    struct sockaddr_in server_addr;
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(SERVER_PORT);
    if (bind(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("Error binding socket");
        exit(1);
    }

    // Listen for clients
    listen(sockfd, 10);

    // Accept a client connection
    newsockfd = accept(sockfd, NULL, NULL);
    if (newsockfd < 0) {
        perror("Error accepting client connection");
        exit(1);
    }

    // Receive data from the client
    read_size = recv(newsockfd, buffer, BUFFER_SIZE, 0);
    if (read_size < 0) {
        perror("Error receiving data");
        exit(1);
    }

    // Send data to the client
    write_size = send(newsockfd, buffer, read_size, 0);
    if (write_size < 0) {
        perror("Error sending data");
        exit(1);
    }

    // Close the client connection
    close(newsockfd);

    return 0;
}