//LLAMA2-13B DATASET v1.0 Category: Password management ; Style: scientific
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PASSWORDS 10
#define MAX_LENGTH 20

// Structure to store password information
struct password {
    char *name;
    char *password;
    int age;
};

// Function to generate a random password
void generate_password(struct password *pwd) {
    int i, j;
    char password[MAX_LENGTH];

    for (i = 0; i < MAX_LENGTH; i++) {
        password[i] = 'a' + (rand() % 26);
    }

    pwd->password = password;
}

// Function to check if a password is valid
int check_password(struct password *pwd, char *input) {
    int i, j;

    for (i = 0; i < MAX_LENGTH; i++) {
        if (pwd->password[i] != input[i]) {
            return 0;
        }
    }

    return 1;
}

// Function to add a new password
void add_password(struct password *pwd, char *name) {
    int i;
    char password[MAX_LENGTH];

    generate_password(pwd);

    // Store the password in the structure
    pwd->name = name;
    pwd->password = password;

    // Increment the age of the password
    pwd->age++;
}

// Function to display the list of passwords
void display_passwords(struct password *pwd) {
    int i;

    printf("List of Passwords:\n");

    for (i = 0; i < MAX_PASSWORDS; i++) {
        if (pwd[i].name != NULL) {
            printf("%d. %s (%d days old)\n", i + 1, pwd[i].name, pwd[i].age);
        }
    }
}

int main() {
    struct password pwd[MAX_PASSWORDS];
    int i, j;

    // Initialize the password structure
    for (i = 0; i < MAX_PASSWORDS; i++) {
        pwd[i].name = NULL;
        pwd[i].password = NULL;
        pwd[i].age = 0;
    }

    // Add some passwords
    add_password(pwd, "John Doe");
    add_password(pwd, "Jane Doe");
    add_password(pwd, "Bob Smith");

    // Display the list of passwords
    display_passwords(pwd);

    return 0;
}