//LLAMA2-13B DATASET v1.0 Category: Encryption ; Style: systematic
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#define KEY_SIZE 16
#define BLOCK_SIZE 16

// Function to generate a random key
void generate_key() {
    int i, j;
    unsigned char key[KEY_SIZE];

    for (i = 0; i < KEY_SIZE; i++) {
        key[i] = rand() % 256;
    }

    printf("Generated key: ");
    for (i = 0; i < KEY_SIZE; i++) {
        printf("%02x", key[i]);
    }
    printf("\n");
}

// Function to encrypt a block of data
void encrypt_block(unsigned char *data, unsigned char *key) {
    int i, j;
    unsigned char temp[BLOCK_SIZE];

    for (i = 0; i < BLOCK_SIZE; i++) {
        temp[i] = data[i] ^ key[i % KEY_SIZE];
    }

    for (i = 0; i < BLOCK_SIZE; i++) {
        data[i] = temp[i];
    }
}

// Function to decrypt a block of data
void decrypt_block(unsigned char *data, unsigned char *key) {
    int i, j;
    unsigned char temp[BLOCK_SIZE];

    for (i = 0; i < BLOCK_SIZE; i++) {
        temp[i] = data[i] ^ key[i % KEY_SIZE];
    }

    for (i = 0; i < BLOCK_SIZE; i++) {
        data[i] = temp[i];
    }
}

int main() {
    unsigned char key[KEY_SIZE];
    unsigned char data[BLOCK_SIZE];
    int choice;

    // Generate a random key
    generate_key();

    // Ask the user to enter the data to be encrypted
    printf("Enter the data to be encrypted (maximum %d bytes): ", BLOCK_SIZE);
    fread(data, 1, BLOCK_SIZE, stdin);

    // Ask the user to select the encryption mode (0 for encryption, 1 for decryption)
    choice = getchar();

    // Encrypt or decrypt the data
    if (choice == '0') {
        encrypt_block(data, key);
        printf("Encrypted data: ");
        for (int i = 0; i < BLOCK_SIZE; i++) {
            printf("%02x", data[i]);
        }
        printf("\n");
    } else if (choice == '1') {
        decrypt_block(data, key);
        printf("Decrypted data: ");
        for (int i = 0; i < BLOCK_SIZE; i++) {
            printf("%02x", data[i]);
        }
        printf("\n");
    }

    return 0;
}