//Code Llama-13B DATASET v1.0 Category: Geometric algorithms ; Style: authentic
/*
 * Geometric algorithms example program
 *
 * Written in an authentic style
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define PI 3.14159265358979323846

// Struct to store points
typedef struct {
  double x;
  double y;
} point_t;

// Function to calculate distance between two points
double distance(point_t p1, point_t p2) {
  return sqrt((p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y));
}

// Function to calculate area of a triangle
double triangle_area(point_t p1, point_t p2, point_t p3) {
  return (p1.x * (p2.y - p3.y) + p2.x * (p3.y - p1.y) + p3.x * (p1.y - p2.y)) / 2.0;
}

// Function to calculate the circumference of a circle
double circle_circumference(double radius) {
  return 2.0 * PI * radius;
}

// Function to calculate the area of a circle
double circle_area(double radius) {
  return PI * radius * radius;
}

int main() {
  point_t p1, p2, p3;

  // Calculate distance between two points
  p1.x = 2.0;
  p1.y = 3.0;
  p2.x = 4.0;
  p2.y = 5.0;
  printf("Distance between (%lf, %lf) and (%lf, %lf) is %lf\n", p1.x, p1.y, p2.x, p2.y, distance(p1, p2));

  // Calculate area of a triangle
  p1.x = 1.0;
  p1.y = 1.0;
  p2.x = 2.0;
  p2.y = 1.0;
  p3.x = 1.5;
  p3.y = 2.0;
  printf("Area of triangle (%lf, %lf), (%lf, %lf), (%lf, %lf) is %lf\n", p1.x, p1.y, p2.x, p2.y, p3.x, p3.y, triangle_area(p1, p2, p3));

  // Calculate circumference of a circle
  double radius = 2.0;
  printf("Circumference of circle with radius %lf is %lf\n", radius, circle_circumference(radius));

  // Calculate area of a circle
  radius = 3.0;
  printf("Area of circle with radius %lf is %lf\n", radius, circle_area(radius));

  return 0;
}