//GPT-4o-mini DATASET v1.0 Category: Error handling ; Style: multiplayer
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define GRID_SIZE 5
#define MAX_PLAYERS 3
#define TREASURE_SYMBOL 'T'
#define EMPTY_SYMBOL '.'
#define PLAYER_SYMBOL 'P'

typedef struct {
    int x;
    int y;
    char symbol;
} Player;

typedef struct {
    char grid[GRID_SIZE][GRID_SIZE];
    Player players[MAX_PLAYERS];
    int treasure_x;
    int treasure_y;
    int player_count;
} Game;

void initializeGame(Game *game) {
    memset(game->grid, EMPTY_SYMBOL, sizeof(game->grid));
    
    // Place the treasure randomly
    game->treasure_x = rand() % GRID_SIZE;
    game->treasure_y = rand() % GRID_SIZE;
    
    game->grid[game->treasure_x][game->treasure_y] = TREASURE_SYMBOL;

    game->player_count = 0;
}

void addPlayer(Game *game, int x, int y) {
    if (game->player_count >= MAX_PLAYERS) {
        fprintf(stderr, "Error: Maximum number of players reached!\n");
        return;
    }
    if (x < 0 || x >= GRID_SIZE || y < 0 || y >= GRID_SIZE) {
        fprintf(stderr, "Error: Invalid player position!\n");
        return;
    }
    if (game->grid[x][y] != EMPTY_SYMBOL) {
        fprintf(stderr, "Error: Position already occupied!\n");
        return;
    }

    Player newPlayer = {x, y, PLAYER_SYMBOL};
    game->players[game->player_count++] = newPlayer;
    game->grid[x][y] = PLAYER_SYMBOL;
}

void displayGrid(Game *game) {
    printf("\nGameplay Grid:\n");
    for (int i = 0; i < GRID_SIZE; i++) {
        for (int j = 0; j < GRID_SIZE; j++) {
            printf("%c ", game->grid[i][j]);
        }
        printf("\n");
    }
    printf("\n");
}

int movePlayer(Game *game, int playerIndex, int new_x, int new_y) {
    if (playerIndex < 0 || playerIndex >= game->player_count) {
        fprintf(stderr, "Error: Invalid player index!\n");
        return -1;
    }

    Player *player = &game->players[playerIndex];

    if (new_x < 0 || new_x >= GRID_SIZE || new_y < 0 || new_y >= GRID_SIZE) {
        fprintf(stderr, "Error: Move out of bounds!\n");
        return -1;
    }
  
    if (game->grid[new_x][new_y] != EMPTY_SYMBOL) {
        fprintf(stderr, "Error: Target position is occupied!\n");
        return -1;
    }

    // Update the grid
    game->grid[player->x][player->y] = EMPTY_SYMBOL; // Clear old position
    player->x = new_x;
    player->y = new_y;
    game->grid[new_x][new_y] = PLAYER_SYMBOL; // Set new position

    return 0;
}

int checkForTreasure(Game *game, int playerIndex) {
    if (playerIndex < 0 || playerIndex >= game->player_count) {
        fprintf(stderr, "Error: Invalid player index!\n");
        return -1;
    }

    Player *player = &game->players[playerIndex];
    
    if (player->x == game->treasure_x && player->y == game->treasure_y) {
        printf("Player %d found the treasure at (%d, %d)!\n", playerIndex + 1, player->x, player->y);
        return 1; // found treasure
    }
    return 0; // not found
}

int main() {
    srand(time(0));
    
    Game game;
    initializeGame(&game);

    // Add players to the game
    addPlayer(&game, 0, 0);
    addPlayer(&game, 1, 1);
    addPlayer(&game, 2, 2);

    displayGrid(&game);

    // Players try to move and check for treasure
    int moves[MAX_PLAYERS][2] = {
        {0, 1}, // Player 1 tries to move right
        {1, 2}, // Player 2 tries to move down
        {0, 2}  // Player 3 tries to move down and right to (0,2)
    };

    for (int i = 0; i < game.player_count; i++) {
        if (movePlayer(&game, i, moves[i][0], moves[i][1]) == 0) {
            displayGrid(&game);
            if (checkForTreasure(&game, i)) {
                printf("Player %d has successfully finished the game!\n", i + 1);
            } else {
                printf("Player %d did not find the treasure.\n", i + 1);
            }
        }
    }

    return 0;
}