//Falcon2-11B DATASET v1.0 Category: Database querying ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>

int main() {
    sqlite3 *db;
    int rc;
    char *zErrMsg = 0;

    rc = sqlite3_open("example.db", &db);
    if (rc) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        return 1;
    }

    rc = sqlite3_exec(db, "CREATE TABLE IF NOT EXISTS people (id INTEGER PRIMARY KEY, name TEXT, age INTEGER)", NULL, NULL, &zErrMsg);
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
        return 1;
    }

    rc = sqlite3_exec(db, "INSERT INTO people VALUES (1, 'John Doe', 25)", NULL, NULL, &zErrMsg);
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
        return 1;
    }

    rc = sqlite3_exec(db, "SELECT * FROM people WHERE name='John Doe'", NULL, NULL, &zErrMsg);
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
        return 1;
    }

    printf("Name: %s, Age: %d\n", zErrMsg, zErrMsg);

    rc = sqlite3_exec(db, "DELETE FROM people WHERE name='John Doe'", NULL, NULL, &zErrMsg);
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
        return 1;
    }

    rc = sqlite3_exec(db, "SELECT * FROM people", NULL, NULL, &zErrMsg);
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
        return 1;
    }

    printf("Name: %s, Age: %d\n", zErrMsg, zErrMsg);

    rc = sqlite3_close(db);
    if (rc) {
        fprintf(stderr, "Error closing database: %s\n", sqlite3_errmsg(db));
    }

    return 0;
}