//Falcon2-11B DATASET v1.0 Category: TCP/IP Programming ; Style: accurate
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

// Function to print the error message
void printError(const char *msg) {
    perror(msg);
    exit(1);
}

// Function to create a TCP/IP socket
int createSocket() {
    int sockfd;
    struct sockaddr_in server;

    // Initialize socket structure
    memset((char *)&server, '\0', sizeof(server));
    server.sin_family = AF_INET;
    server.sin_port = htons(8080);
    server.sin_addr.s_addr = INADDR_ANY;

    // Create socket
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        printError("Error creating socket");
    }

    return sockfd;
}

// Function to connect to the server
int connectToServer() {
    int sockfd, len;
    struct sockaddr_in server;

    // Initialize socket structure
    memset((char *)&server, '\0', sizeof(server));
    server.sin_family = AF_INET;
    server.sin_port = htons(8080);
    server.sin_addr.s_addr = inet_addr("127.0.0.1");

    // Connect to the server
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        printError("Error connecting to server");
    }

    if (connect(sockfd, (struct sockaddr *)&server, sizeof(server)) < 0) {
        printError("Error connecting to server");
    }

    return sockfd;
}

// Function to send a message to the server
int sendMessage(int sockfd, const char *msg) {
    int len;
    char buffer[1024];

    // Convert message to bytes
    len = sprintf(buffer, "%s", msg);

    // Send message to server
    if (send(sockfd, buffer, len, 0) < 0) {
        printError("Error sending message");
    }

    return 0;
}

// Function to receive a message from the server
int receiveMessage(int sockfd, char *buffer, int size) {
    int len;

    // Receive message from server
    if ((len = recv(sockfd, buffer, size, 0)) < 0) {
        printError("Error receiving message");
    }

    return len;
}

int main(int argc, char *argv[]) {
    int sockfd, len;
    struct sockaddr_in server;
    char buffer[1024];

    // Create a TCP/IP socket
    if ((sockfd = createSocket()) < 0) {
        printError("Error creating socket");
    }

    // Connect to the server
    if ((sockfd = connectToServer()) < 0) {
        printError("Error connecting to server");
    }

    // Receive message from the server
    len = receiveMessage(sockfd, buffer, sizeof(buffer));
    printf("Received message: %s\n", buffer);

    // Send a message to the server
    sprintf(buffer, "Hello, server!\n");
    sendMessage(sockfd, buffer);

    // Close the socket
    close(sockfd);

    return 0;
}