//Falcon-180B DATASET v1.0 Category: Resume Parsing System ; Style: calm
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_TOKENS 100
#define MAX_TOKEN_LEN 100

typedef struct {
    char *value;
    int length;
} Token;

Token tokens[MAX_TOKENS];
int num_tokens = 0;

char *read_line(FILE *fp) {
    char *line = NULL;
    size_t len = 0;
    getline(&line, &len, fp);
    return line;
}

void split_line(char *line) {
    char *token = strtok(line, ",.!?;:");
    while (token!= NULL) {
        if (num_tokens >= MAX_TOKENS) {
            fprintf(stderr, "Error: Too many tokens in line.\n");
            exit(1);
        }
        tokens[num_tokens].value = strdup(token);
        tokens[num_tokens].length = strlen(token);
        num_tokens++;
        token = strtok(NULL, ",.!?;:");
    }
}

void print_tokens() {
    for (int i = 0; i < num_tokens; i++) {
        printf("%s (%d)\n", tokens[i].value, tokens[i].length);
    }
}

int main() {
    FILE *fp = fopen("resume.txt", "r");
    if (fp == NULL) {
        fprintf(stderr, "Error: Could not open file.\n");
        exit(1);
    }

    char *line = NULL;
    while ((line = read_line(fp))!= NULL) {
        split_line(line);
    }

    print_tokens();

    for (int i = 0; i < num_tokens; i++) {
        free(tokens[i].value);
    }

    fclose(fp);
    return 0;
}