//Falcon-180B DATASET v1.0 Category: Electronic Voting System ; Style: scalable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CANDIDATES 10
#define MAX_VOTERS 1000

typedef struct {
    char name[50];
    int votes;
} candidate;

typedef struct {
    char name[50];
    int vote;
} voter;

candidate candidates[MAX_CANDIDATES];
voter voters[MAX_VOTERS];
int num_candidates = 0;
int num_voters = 0;

void add_candidate(char* name) {
    strcpy(candidates[num_candidates].name, name);
    candidates[num_candidates].votes = 0;
    num_candidates++;
}

void add_voter(char* name) {
    strcpy(voters[num_voters].name, name);
    num_voters++;
}

void vote(int candidate_index, int voter_index) {
    candidates[candidate_index].votes++;
    voters[voter_index].vote = candidate_index;
}

void print_results() {
    int i, j;
    for(i=0; i<num_candidates; i++) {
        printf("%s: %d votes\n", candidates[i].name, candidates[i].votes);
    }
}

int main() {
    add_candidate("John");
    add_candidate("Jane");
    add_candidate("Bob");

    add_voter("Alice");
    add_voter("Bob");
    add_voter("Charlie");

    vote(0, 0);
    vote(1, 1);
    vote(2, 2);

    print_results();

    return 0;
}