//GPT-4o-mini DATASET v1.0 Category: Elevator Simulation ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define MAX_FLOORS 10
#define MAX_PEOPLE 5

typedef struct {
    int current_floor;
    int destination_floor;
    int id;
} Person;

typedef struct {
    int current_floor;
    int direction; // 1 for up, -1 for down, 0 for idle
    Person *people[MAX_PEOPLE];
} Elevator;

void initialize_elevator(Elevator *elevator) {
    elevator->current_floor = 0;
    elevator->direction = 0;
    for (int i = 0; i < MAX_PEOPLE; i++) {
        elevator->people[i] = NULL;
    }
}

void print_status(Elevator *elevator) {
    printf("Elevator is on floor: %d, ", elevator->current_floor);
    switch (elevator->direction) {
        case 1: printf("Direction: Up\n"); break;
        case -1: printf("Direction: Down\n"); break;
        default: printf("Direction: Idle\n"); break;
    }
}

void add_person(Elevator *elevator, Person *person) {
    for (int i = 0; i < MAX_PEOPLE; i++) {
        if (elevator->people[i] == NULL) {
            elevator->people[i] = person;
            printf("Person %d added to the elevator.\n", person->id);
            return;
        }
    }
    printf("Elevator is full! Person %d cannot enter.\n", person->id);
}

void remove_person(Elevator *elevator, int person_id) {
    for (int i = 0; i < MAX_PEOPLE; i++) {
        if (elevator->people[i] != NULL && elevator->people[i]->id == person_id) {
            printf("Person %d has exited the elevator at floor %d.\n", person_id, elevator->current_floor);
            free(elevator->people[i]);
            elevator->people[i] = NULL;
            return;
        }
    }
    printf("Person %d is not in the elevator.\n", person_id);
}

void simulate_elevator(Elevator *elevator) {
    while (1) {
        int people_count = 0;
        for (int i = 0; i < MAX_PEOPLE; i++) {
            if (elevator->people[i] != NULL) {
                people_count++;
                if (elevator->current_floor == elevator->people[i]->destination_floor) {
                    remove_person(elevator, elevator->people[i]->id);
                }
            }
        }

        if (people_count == 0) {
            elevator->direction = 0; // Idle if no people
            printf("No people in the elevator. Going idle...\n");
            sleep(2);
            continue;
        }

        for (int i = 0; i < MAX_FLOORS; i++) {
            if (elevator->people[i] != NULL && elevator->people[i]->destination_floor > elevator->current_floor) {
                elevator->direction = 1; // Up
                break;
            } else if (elevator->people[i] != NULL && elevator->people[i]->destination_floor < elevator->current_floor) {
                elevator->direction = -1; // Down
                break;
            }
        }

        print_status(elevator);

        if (elevator->direction == 1 && elevator->current_floor < MAX_FLOORS - 1) {
            elevator->current_floor++;
        } else if (elevator->direction == -1 && elevator->current_floor > 0) {
            elevator->current_floor--;
        }

        sleep(1);
    }
}

int main() {
    Elevator elevator;
    initialize_elevator(&elevator);

    for (int i = 1; i <= 5; i++) {
        Person *person = (Person *)malloc(sizeof(Person));
        person->id = i;
        person->destination_floor = rand() % MAX_FLOORS;
        person->current_floor = 0;
        add_person(&elevator, person);
    }

    simulate_elevator(&elevator);

    return 0;
}